Attribute VB_Name = "mdMakeTangentLineCircle"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to make a line and a circle tangent

Sub MakeTangentLineCircle(lineObj As aLine, circleObj As aLine)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim wp As aWorkplane
Set wp = lineObj.GetParent("Workplane")

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim zcon As zTangent
Set zcon = app.GetClass("Tangent").CreateTangent(lineObj, circleObj)

If (wp.GetConstraint(zcon) Is Nothing) Then
    wp.CreateConstraint zcon
Else
    zcon.Delete
End If

End Sub


